<?php 
   /**
    *
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-l%27uso-del-logo-geecom
    *
    */

    include "../include/util.php";
    include "../include/costanti.php";
    include "../gUtil/DbManager.php";
    include "../gUtil/ControlloreStringhe.php";
    include "../classi/TemplateCartelle.php";
    include "../classi/GestoreStoricoOperazioni.php";
    include "../classi/GeneratoreUrl.php";
    
    //i dati del database sono definiti nel file costanti.php
    $geecomDb = new DbManager($costantiDatabase);
    $gestoreStoricoOperazioni = new GestoreStoricoOperazioni($geecomDb,"Doc");
    
    // le impostazioni servono per ottenere l'indirizzo del sito da inviare al server
    $impostazioni = $geecomDb->leggiSingolaRiga("geecD_impostazioni", 1);
    
    session_start();
    controlloAccessoAdmin();
    if(isset($_POST["operazione"])) {
        $operazione = filter_input(INPUT_POST,"operazione",FILTER_SANITIZE_STRING);
        $templateCartelle = new TemplateCartelle($geecomDb, filter_input(INPUT_POST, "id"));
    }
    else {
        $operazione = filter_input(INPUT_GET,"operazione",FILTER_SANITIZE_STRING);
        $templateCartelle = new TemplateCartelle($geecomDb, filter_input(INPUT_GET, "id"));
    }
    
    // dato che serve in molti switch per capire la pagina a cui l'utente deve essere rediretto
    $datiProdottoGeecom = $geecomDb->leggiSingolaRiga("geec_prodotti", 3) ;
    $percorsoGeecomDoc = GeneratoreUrl::creaUrlAreaAmministrativa($impostazioni,$datiProdottoGeecom);
    
    switch ($operazione) {
        case 'crea':
            $templateCartelle->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
            $templateCartelle->setDescrizione(filter_input(INPUT_POST,"descrizione",FILTER_SANITIZE_ADD_SLASHES));
            $templateCartelle->crea();
            header("Location: $percorsoGeecomDoc/creaTemplateCartelle.php?id={$templateCartelle->getId()}&status=200");
            break;
        case 'modifica':
            $templateCartelle->setCartellaCollegata(filter_input(INPUT_POST,"cartellaCollegata",FILTER_SANITIZE_NUMBER_INT));
            $templateCartelle->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
            $templateCartelle->setDescrizione(filter_input(INPUT_POST,"descrizione",FILTER_SANITIZE_ADD_SLASHES));
            $templateCartelle->modifica();
            header("Location: $percorsoGeecomDoc/creaTemplateCartelle.php?id={$templateCartelle->getId()}&status=220");
            break;
        case 'elimina':
            $templateCartelle->elimina();
            echo "ok";
            break;
    }